const voyagerElement = document.getElementById("voyager");
const ecorpusContainerElement = document.getElementById("ecorpusContainerId");
const shadowRootElement = document.getElementById("voyager").shadowRoot;
const resetButtonElement = shadowRootElement.getElementById("main-reset");
const explodedViewInstructionsElement = document.getElementById('explodedViewInstructions');
const welcomeArticleElement = document.getElementById("welcomeArticleId");
const tourStepsElements = document.getElementById("tourButtons").getElementsByClassName("tour-step");
// const backdropBlurElement = document.getElementById("backdropBlurId");
// const zodiacRangeElement = document.getElementById("zodiacRange");
console.log("VOYAGER ELEMENT ", voyagerElement);
const articles = document.getElementsByClassName("articleContainer");
// const sceneLink = "http://192.168.1.143:8000/scenes/Roue de Barlow pour l'appli/";
const sceneLink = "../../Roue de Barlow pour l'appli/";
// let pageStack=[]
let currentPage;
let stepTimeoutID;

// ============ UTILS FOR VOYAGER UI ==============
let toursVisible = false;
let annotationVisible = false;
function setToursVisibility(bool) {
    if (toursVisible != bool) {
        voyagerElement.toggleTours();
        toursVisible = bool;
    }
}

function setAnnotationsVisibility(bool) {
    if (annotationVisible != bool) {
        voyagerElement.toggleAnnotations();
        annotationVisible = bool;
    }
}

function resetVoyager() {
    resetButtonElement.click();
    setToursVisibility(false);
    setTimeout(() => voyagerElement.setLanguage(languageSelect.value), 100); // TODO cleanup ?
}

// Hide or make visible a blur div in front of the voyager sccene (and anything with z-index <4)
function blurs(bool) {
    backdropBlurElement.style = 'visibility: ' + (bool ? 'visible;' : 'hidden;')
}

// ========== INTERNATIONALISATION ========
voyagerElement.onload = "setLanguage(languageSelect.value); console.log('HERE !', this),  this.setTourStep(0, 0, false)"
let currentLanguage = "fr";

const translatedElements = document.getElementsByClassName("translate");
i18n = {
    mainMenuButtonId: { fr: "Menu principal", en: "Main menu" },
    menuTitleId: { fr: "Le Globe Céleste", en: "The Celestial globe" },
    menuSubtitleId: { fr: "de Coronelli", en: "by Coronelli" },
    zodiacMenuButtonId: { fr: "Le Zodiaque", en: "The Zodiac" },
    globeMenuButtonId: { fr: "Créer le globe", en: "Making the globe" },
    exploreMenuButtonId: { fr: "Explorer", en: "Explore" },
};

function setLanguage(language) {
    voyagerElement.setLanguage(language);
    if (currentLanguage != language) {
        currentLanguage = language;
        setArticleContent(welcomeArticleElement, "new-article-5WNTa4aRHqc2");
        for (element of translatedElements) {
            console.log(element);
            element.innerHTML = i18n[element.id][language];
        }
    }
}

// ====== CHANGING VOYAGER CSS =====
const shadowRootStyleTag = document.createElement("style");
shadowRootStyleTag.textContent = "\
sv-content-view, sv-chrome-view {\
    --color-accent-1-rgb: 3, 62, 92;\
    --color-text : #f8f7e5  \
}\
.sv-content-split .sv-reader-container {margin-top: 0px;}\
.sv-nav-button:nth-of-type(2) {visibility:hidden}\
.sv-standard-annotation, .sv-extended-annotation{\
    color: var(--color-text);\
    background-color: rgba(var(--color-accent-1-rgb),0.75);\
    font-family: 'Source Sans Pro', sans-serif;\
    font-size: 1.2rem;\
    .sv-title{\
        font-weight: normal;\
    }\
    p {\
        font-family: 'Source Sans Pro', sans-serif;\
        font-weight: lighter;\
        font-size: 0.58em;\
        color: #c8c8c8;\
    }\
}\
.sv-standard-annotation.sv-expanded, .sv-extended-annotation.sv-expanded {\
    background-color: rgba(var(--color-accent-1-rgb),1);\
}\
.sv-article h1:before{\
    background-color: rgba(var(--color-accent-1-rgb),1); \
}\
.sv-article h1 , .sv-article p {\
    font-family: 'Source Sans Pro', 'Hind Siliguri', sans-serif;\
}\
.sv-blue-bar{\
    background-color: rgba(var(--color-accent-1-rgb),0.85);\
    border-left: 1px solid rgba(var(--color-accent-1-rgb),0.5);\
    border-right: 1px solid rgba(var(--color-accent-1-rgb),0.5);\
    color: var(--color-text);\
    .ff-icon{\
         fill:currentColor;\
    }\
}\
.sv-blue-bar .sv-section {\
    border-top:  1px solid rgba(var(--color-accent-1-rgb),0.5);\
}\
.sv-blue-bar  .sv-section-trail {\
    border-left:  1px solid rgba(var(--color-accent-1-rgb),0.5);\
}\
.sv-tour-menu{\
  left: 252px;\
}\
.sv-chrome-view{\
    backgroundelement:transparent;\
    sv-tag-cloud{\
        visibility: hidden;\
    }\
}\
";
shadowRootElement.appendChild(shadowRootStyleTag);
resetButtonElement.style = "visibility:hidden;";

// // ==================== LOADING AND CHANGING ARTICLES ================
setArticleContent(welcomeArticleElement, "new-article-5WNTa4aRHqc2");
// setArticleContent(zodiacArticleElement, "new-article-ecjibrJMHJ9p");
function setArticleContent(articleHTMLElement, article_uid) {
    const req = new XMLHttpRequest();
    req.addEventListener("load", () => {
        console.log("set Article Content");
        let article = new DOMParser().parseFromString(req.response, "text/html");
        //Rewritting relative links to absolute ones.
        for (attr of ['src', 'href']) {
            linksElement = article.querySelectorAll(`[${attr}]`)
            for (element of linksElement) {
                if ((!(element.attributes[attr].value.indexOf('http://') === 0)) && (!(element.attributes[attr].value.indexOf('https://') === 0))) {
                    element.attributes[attr].value = sceneLink + "articles/" + element.attributes[attr].value;
                }
            }
        }
        articleHTMLElement.innerHTML = article.body.innerHTML;
        //addTouchTooltips(articleHTMLElement);
        //addBiblioLinks(articleHTMLElement);
        //console.log('articleHTMLElement.closest(".scrollableTooltipContainer")', articleHTMLElement.closest("s.crollableTooltipContainer"));
        //articleHTMLElement.closest(".scrollableTooltipContainer").addEventListener("scroll", removeAllTooltips);
    });
    req.open("GET", sceneLink + "articles/" + article_uid + "-" + currentLanguage.toUpperCase() + ".html");
    req.send();
}

// // ==================== PORTRAITS GALLERY ================
// const miniPortraits = document.getElementsByClassName("miniportrait");
// let portraitsArticles = {
//     "LouisIVMiniportraitID": "new-article-Fq3rHXAoNhlb",
//     "CorneilleMiniportraitID": "new-article-s0554qDiygrA",
//     "ColbertMiniportraitID": "new-article-aRhlO7Jg1D5n",
//     "dEstreesMiniportraitID": "new-article-zyuMJEvsIvhc",
//     "NolinMiniportraitID": "new-article-h2HBEjbvuqxD",
//     "deVuezMiniportraitID": "new-article-UXFTQLkmMpu6",
//     "CoronelliMiniportraitID": "new-article-C3OUYWVu228Q",
//     "CharpentierMiniportraitID": "new-article-ebyt56p1zeSX",
// }
// let selectedPortrait;

// for (let portrait of document.getElementById("portaitsGalleryId").children) {
//     console.log(portrait);
//     portrait.addEventListener("click", (ev) => {
//         selectedPortrait = portrait.dataset.target;
//         showPortraitPage(selectedPortrait)
//     })
// }

// for (let miniportrait of miniPortraits) {
//     miniportrait.addEventListener("click", (ev) => {
//         selectedPortrait = miniportrait.id;
//         for (portrait of miniPortraits) {
//             if (portrait.id == selectedPortrait) {
//                 portrait.classList.add("selected")
//             } else {
//                 portrait.classList.remove("selected")
//             }
//             setArticleContent(portraitArticleElement, portraitsArticles[selectedPortrait]);
//         }
//     });
// }
// function showPortraitPage(selectedPortrait, overlay = false) {
//     document.getElementById(selectedPortrait).click();
//     showPage("portraitsPage", overlay);
// }

// ==================== HANDLING PAGES ==============================

let elementByPages = {
    mainPage: document.getElementsByClassName("mainPage"),
    alimentationPage: document.getElementsByClassName("alimentationPage"),
    explodedViewPage: document.getElementsByClassName("explodedViewPage"),
    welcomePage: document.getElementsByClassName("welcomePage")
}

function showPage(pageName, overlay = false) {
    currentPage = pageName;
    console.log(currentPage);
    for (const [key, htmlElements] of Object.entries(elementByPages)) {
        for (element of htmlElements) {
            if (element.classList.contains(pageName)) {
                element.style.visibility = "visible"
            } else if (!overlay) {
                element.style.visibility = "hidden"
            }
        }
    }

    if (pageName == "explodedViewPage") {
        const shadowRootStyleTag = document.createElement("style");

        shadowRootStyleTag.textContent = "\
        .sv-standard-annotation, .sv-extended-annotation{\
            border: 1px #ff0000 solid;\
            animation: blink 1s;\
            animation-iteration-count: 5;\
        }\
        @keyframes blink { 50% { border-color:#fff ; } }\
        }\
    ";
        shadowRootElement.appendChild(shadowRootStyleTag);
        explodedViewInstructionsElement.classList.add("disapearing");
        setTimeout(() => {
            shadowRootElement.removeChild(shadowRootElement.lastChild);
            explodedViewInstructionsElement.style = "visibility: hidden";
            explodedViewInstructionsElement.classList.remove("disapearing")
        }, 5000)
    }
    // if (pageName == "zodiacPage") {
    //     zodiacRangeElement.value = 0;
    //     voyagerElement.setTourStep(2, 0, true);
    // }

    // // Tours UI is visible only on the explore page
    // setToursVisibility(pageName == "explorePage");


    // //reset globe position when going to main Page
    // if (pageName == "mainMenuPage") {
    //     console.log("Camera Offset", voyagerElement.getCameraOffset());
    //     resetVoyager();
    // }

    //reset articles scroll
    for (article of articles) {
        article.scrollTop = 0;
    }

}

// // Should only be used on pages that can be overlayed
// // showPage makes sure that other pages are closed.
// function popPage() {
//     console.log("pop page stack", pageStack);
//     showPage(pageStack.pop() ?? "mainMenuPage");
// }

// // Used to  close the article currently opened when clicking outside of it
// // Relies on the fact that the first element children of an article is the close button
// // Simulates clicking on the close button as not all articles perform the same actions on closing.
// function closeOpenedArticle() {
//     for (article of articles) {
//         if (article.checkVisibility({ visibilityProperty: true })) {
//             article.firstElementChild.click()
//         }
//     }
// }

// // ============ TOUCHSCREEN TOOLTIPS ==============

// //example tooltip : <p>This is a test for <span class="tooltip-text" title="This is an example tooltip">tooltips</span> !</p>
// function addTouchTooltips(article) {
//     let tooltipSpans = article.getElementsByClassName("tooltip-text");
//     for (span of tooltipSpans) {
//         span.setAttribute('data-tooltip', span.title);
//         span.removeAttribute('title');

//         span.addEventListener("click", (event) => {
//             { tooltipMouseOver(event.target) };
//             setDisapearTimeout(event.target);
//         });

//         // Mouse interaction !
//         /*span.addEventListener("mouseover", (event) => {tooltipMouseOver(event.target)});
//         span.addEventListener("mouseout", (event) => {
//             console.log("MOUSE OUT");
//             console.log(span);
//             if (span.nextElementSibling && span.nextElementSibling.classList.contains("tooltip")) {
//                 span.nextElementSibling.remove();
//             }
//         });*/
//     }
//     return (article);
// };


// function removeAllTooltips() {
//     let tooltipSpans = document.getElementsByClassName("tooltip-text");
//     clearTimeout(tooltipsTimeout);
//     for (s of tooltipSpans) {
//         const next = s.nextElementSibling
//         if (next && next.classList.contains('tooltip')) {
//             next.remove()
//         }
//     }
// }

// // Handling user clicking multiple times on a tooltip span
// let tooltipsTimeout;
// function setDisapearTimeout(target) {
//     clearTimeout(tooltipsTimeout);
//     tooltipsTimeout = setTimeout(() => {
//         target.nextElementSibling.animate(
//             [{ opacity: 1 },
//             { opacity: 0 }],
//             { duration: 500 }
//         );
//         console.log("target.nextElementSibling.style", target.nextElementSibling.style.cssText);
//         target.nextElementSibling.style = target.nextElementSibling.style.cssText + " opacity: 0;";
//     }, 4000)
// }


// function tooltipMouseOver(span) {
//     removeAllTooltips()

//     tooltip = document.createElement("span");
//     tooltip.classList.add("tooltip");
//     tooltip.appendChild(document.createTextNode(span.dataset.tooltip));
//     span.insertAdjacentElement("afterend", tooltip);

//     // tooltip position 
//     const rect = span.getBoundingClientRect();
//     const left = rect.left + rect.width + 4;
//     const top = rect.top - 4;
//     span.nextElementSibling.style = "left: " + left + "px; top: " + top + "px;";
// }


// // ============ Add Biblio Links ==============
// //<span class="biography-link" data-target="dEstreesMiniportraitID">cardinal d'Estr&eacute;e</span>
// function addBiblioLinks(article) {
//     let bioLinks = article.getElementsByClassName("biography-link");
//     for (linkSpan of bioLinks) {
//         linkSpan.addEventListener("click", (event) => {
//             if (currentPage != "portraitsPage") {
//                 pageStack.push(currentPage);
//             }
//             console.log("show portrait ", event.target.dataset.target);
//             showPortraitPage(event.target.dataset.target, true);
//         });
//     }
// }

// ============ Inverting Rotation ============
let rotationDirection = 7;
function invertRotation() {
    if (rotationDirection == 7) {
        rotationDirection = 8;
    } else {
        rotationDirection = 7
    }
    voyagerElement.setTourStep(0, rotationDirection, false);
}

// ============ Step clicks ============
for (element of tourStepsElements) {
    element.addEventListener("click", (event) => {
        event.target.classList.remove("unselectedStep");
        event.target.classList.add("selectedStep");
        for (e of tourStepsElements) {
            if (e != event.target) {
                if (e.classList.contains("selectedStep")) {
                    e.classList.remove("selectedStep");
                    e.classList.add("unselectedStep");
                } else {
                    e.classList.remove("unselectedStep");
                }
                if (e.id == "alimentationStepButtonId") {
                    console.log("clearing timout");
                    clearTimeout(stepTimeoutID);
                }
            }
        }
    })
}


showPage("welcomePage");


